/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.entity;

import forge.com.cursee.more_bows_and_arrows.core.entity.TieredArrowEntity;
import forge.com.cursee.more_bows_and_arrows.core.item.TieredBowItem;
import forge.com.cursee.more_bows_and_arrows.core.tier.BowTier;
import forge.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.DragonBreathUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.FireworkUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.PaperEffectsUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ArrowHitsEntityInteractions {
    public static void interact(TieredArrowEntity tieredArrowEntity, @Nullable Entity nullableOwner, EntityHitResult entityHitResult) {
        Entity entity;
        Player player;
        block37: {
            block36: {
                if (!(nullableOwner instanceof Player)) break block36;
                player = (Player)nullableOwner;
                entity = entityHitResult.m_82443_();
                if (entity instanceof LivingEntity) break block37;
            }
            return;
        }
        LivingEntity hitEntity = (LivingEntity)entity;
        switch (tieredArrowEntity.getVariant()) {
            case AMETHYST: 
            case BAMBOO: 
            case COAL: 
            case DIAMOND: 
            case EMERALD: {
                break;
            }
            case BLAZE_ROD: {
                hitEntity.m_20254_(2);
                break;
            }
            case BONE: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40, 1));
                break;
            }
            case CACTUS: {
                hitEntity.m_6469_(player.m_9236_().m_269111_().m_269325_(), 1.5f);
                break;
            }
            case COPPER: {
                Item item = player.m_21205_().m_41720_();
                if (!(item instanceof TieredBowItem)) {
                    return;
                }
                TieredBowItem tieredBowItem = (TieredBowItem)item;
                if (tieredBowItem.tier != BowTier.COPPER) break;
                CommonEffectsUtil.lightingCausedByPlayer(player, hitEntity.m_20183_());
                break;
            }
            case DRAGON_BREATH: {
                DragonBreathUtil.createAreaEffectCloud(player, hitEntity.m_20183_());
                break;
            }
            case DRIPSTONE: {
                hitEntity.m_6469_(player.m_9236_().m_269111_().m_269075_(player), 1.5f);
                break;
            }
            case ECHO: {
                Level level = player.m_9236_();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_5594_(player, hitEntity.m_20183_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case EGG: {
                Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(player.m_9236_());
                if (chicken == null) break;
                chicken.m_6027_((double)hitEntity.m_20183_().m_123341_(), (double)hitEntity.m_20183_().m_123342_(), (double)hitEntity.m_20183_().m_123343_());
                player.m_9236_().m_7967_((Entity)chicken);
                break;
            }
            case ENDER_PEARL: {
                hitEntity.m_6021_(player.f_19854_, player.f_19855_, player.f_19856_);
                break;
            }
            case FIREWORK: {
                FireworkUtil.createRandomFireworkFromEntity((LivingEntity)player, entityHitResult.m_82443_().m_20183_());
                break;
            }
            case FIRE_CHARGE: {
                hitEntity.m_20254_(2);
                break;
            }
            case FLINT: {
                Item item = player.m_21205_().m_41720_();
                if (!(item instanceof TieredBowItem)) break;
                TieredBowItem bow = (TieredBowItem)item;
                if (bow.tier != BowTier.IRON) break;
                hitEntity.m_20254_(2);
                break;
            }
            case FLINT_AND_STEEL: {
                hitEntity.m_20254_(2);
                break;
            }
            case GLOW_INK_SAC: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 80, 1));
                break;
            }
            case ICE: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 2));
                break;
            }
            case INK_SAC: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, 1));
                break;
            }
            case LADDER: {
                player.m_6021_(player.f_19854_, (double)hitEntity.m_20183_().m_123342_(), player.f_19856_);
                break;
            }
            case LIGHTNING_ROD: {
                Item item = player.m_21205_().m_41720_();
                if (!(item instanceof TieredBowItem)) break;
                TieredBowItem tieredBowItem = (TieredBowItem)item;
                if (tieredBowItem.tier != BowTier.LIGHTNING_ROD) break;
                tieredArrowEntity.m_9236_().m_254849_((Entity)player, entityHitResult.m_82443_().f_19854_, entityHitResult.m_82443_().f_19855_, entityHitResult.m_82443_().f_19856_, 4.0f, Level.ExplosionInteraction.TNT);
                break;
            }
            case NETHER_STAR: {
                player.m_9236_().m_254849_((Entity)player, (double)hitEntity.m_20183_().m_123341_(), (double)hitEntity.m_20183_().m_123342_(), (double)hitEntity.m_20183_().m_123343_(), 4.0f, Level.ExplosionInteraction.TNT);
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomEntityEffects(player, hitEntity);
                break;
            }
            case SHEAR: {
                Sheep sheep;
                if (!(hitEntity instanceof Sheep) || !(sheep = (Sheep)hitEntity).m_6220_()) break;
                sheep.m_5851_(SoundSource.PLAYERS);
                sheep.m_146852_(GameEvent.f_157781_, (Entity)player);
                sheep.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 20, 2));
                break;
            }
            case SHULKER_SHELL: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 1));
                break;
            }
            case SLIMEBALL: 
            case SNOWBALL: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 3));
                break;
            }
            case SMOKING: {
                for (int i = 0; i < 3; ++i) {
                    double modifier = player.m_9236_().f_46441_.m_188499_() ? 1.0 : -1.0;
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)hitEntity.m_20183_().m_123341_(), (double)hitEntity.m_20183_().m_123342_() + 1.0, (double)hitEntity.m_20183_().m_123343_(), player.m_9236_().f_46441_.m_188500_() * modifier, player.m_9236_().f_46441_.m_188500_() * modifier, player.m_9236_().f_46441_.m_188500_() * modifier);
                }
                break;
            }
            case TNT: {
                player.m_9236_().m_254849_((Entity)player, (double)hitEntity.m_20183_().m_123341_(), (double)hitEntity.m_20183_().m_123342_(), (double)hitEntity.m_20183_().m_123343_(), 2.0f, Level.ExplosionInteraction.TNT);
                break;
            }
            case WATER_BOTTLE: {
                if (!hitEntity.m_6060_()) {
                    return;
                }
                hitEntity.m_7311_(1);
            }
        }
    }
}

